package ru.yandex.major.config;

public class StorageConfigDefaults
    implements StorageConfig
{
    public static final StorageConfigDefaults INSTANCE =
        new StorageConfigDefaults();

    private static final int DEFAULT_INITIAL_STORAGE_SIZE = 1000000;
    private static final int DEFAULT_MAXIMUM_CAPACITY = 20000000;

    // 72 hours
    private static final int DEFAULT_EXPIRE_TIME = 3600 * 72 * 1000;
    // 10 minutes
    private static final int DEFAULT_DUMP_PERIOD = 10 * 60 * 1000;

    @Override
    public int storageExpireTime() {
        return DEFAULT_EXPIRE_TIME;
    }

    @Override
    public int initialStorageSize() {
        return DEFAULT_INITIAL_STORAGE_SIZE;
    }

    @Override
    public int maximumCapacity() {
        return DEFAULT_MAXIMUM_CAPACITY;
    }

    @Override
    public String dumpPath() {
        return null;
    }

    @Override
    public int dumpPeriod() {
        return DEFAULT_DUMP_PERIOD;
    }
}
