#!/bin/bash
set -o pipefail

CONFIG=${CONFIG:-consumermap.conf}
CONSUMER_GROUP=${CONSUMER_GROUP:-$(jq -r .consumer_group $CONFIG)}
CONSUME_COUNT=$(jq -r ".consume_list[].service" $CONFIG | wc -l)

function generate_map() {
    NUM=$1;
    SERVICE=$(jq -r ".consume_list[$NUM].service" $CONFIG)
    TARGET_HOST=$(jq -r ".consume_list[$NUM].target_host"' // ""' $CONFIG)
    DEFAULT_TARGET_PORT_NAME=${SERVICE}_TARGET_PORT
    TARGET_PORT=$(jq -r ".consume_list[$NUM].target_port"' // ""' $CONFIG)
    TARGET_PORT=${TARGET_PORT:-${!DEFAULT_TARGET_PORT_NAME}}
    TARGET_TIMEOUT=$(jq -r ".consume_list[$NUM].target_timeout // -1" $CONFIG)
    CONSUMER_NAME=$(jq -r ".consume_list[$NUM].consumer_name"' // ""' $CONFIG)
    LOCKNAME=$(jq -r ".consume_list[$NUM].lock_name"' // ""' $CONFIG)
    QUEUES=($(jq -r ".consume_list[$NUM].queues[]" $CONFIG))

    echo "#$SERVICE"
    for q in ${QUEUES[@]}; do
        arr=(${q//:/ })
        group=${arr[0]}
        shards=${arr[1]}
        port=${arr[2]}

        marr=(${group//;/ })

        if [ ${#marr[@]} -gt 1 ]; then
            # multi heads queue detected!
            hostlist=""
            for mq in ${marr[@]}; do
                zkhostlist=$(zk_hostlist $mq)
                if [ $? -ne 0 ]; then
                    echo "Can't obtain hostlist for group $group"
                    exit 1
                fi;
                hostlist="$zkhostlist
$hostlist"
            done;
            ports="$port/$(($port + 1))"
            hosts=$(echo -e "$hostlist" | cut -d ' ' -f 1)
        else
            port=${arr[2]}
            hostlist=$(zk_hostlist $group)
            if [ $? -ne 0 ]; then
                echo "Can't obtain hostlist for group $group"
                exit 1
            fi;
            hosts=$(echo -e "$hostlist" | cut -d ' ' -f 1)
            ports=$(echo $hostlist | cut -d ' ' -f 2 | head -1)
    
        fi;
        
        arr=(${shards//-/ })
        MIN_SHARD=${arr[0]}
        MAX_SHARD=${arr[1]}
        if [ -z "$MAX_SHARD" ]; then
            MAX_SHARD=$MIN_SHARD
        fi
        SHARDS=$((MAX_SHARD-MIN_SHARD+1))
        (
            ZK_PORTS=$ports \
            ZK_HOSTS=$hosts \
            TARGET_HOST=$TARGET_HOST \
            TARGET_PORT=$TARGET_PORT \
            TARGET_TIMEOUT=$TARGET_TIMEOUT \
            LOCKNAME=$LOCKNAME \
            SHARDS=$SHARDS \
            FIRST_SHARD=$MIN_SHARD \
            MAX_SHARD=$((MAX_SHARD+1)) \
            SERVICES=$SERVICE \
            SALO_HOSTS=$CONSUMER_HOSTS \
            CONSUMER_NAME=$CONSUMER_NAME \
	    $(dirname $0)/searchmap-generator.sh
        )
    done
}

function zk_hostlist() {
    GROUP=$1;
#    JSON=$(curl -s api.gencfg.yandex-team.ru/trunk/groups/$GROUP/instances)
    JSON=$(curl -s api.gencfg.yandex-team.ru/trunk/searcherlookup/groups/$GROUP/instances)
    if [ $? -ne 0 ]
    then
        >&2 echo "Curl failed"
        return 1
    fi
    #echo "$JSON" | jq -r '.instances[] | "\(.hostname) \(.port)/\(.port+1)"' \
#	| sort
    echo "$JSON" | jq -r '.instances[] | "\(.hbf.interfaces.backbone.hostname) \(.port)/\(.port+1)"' \
        | sort
}

function consumer_hostlist() {
    for ((group = 1; group <= $#; ++group))
    do
        curl -s api.gencfg.yandex-team.ru/trunk/searcherlookup/groups/${!group}/instances \
            | jq -r '.instances[] | "\(.hbf.interfaces.backbone.hostname) \(.dc)"'
        if [ $? -ne 0 ]
        then
            >&2 echo "Curl failed for consumer group ${!group}"
            return 1
        fi
    done | sort | gawk '
    {
        count++;
        if ($2 in dcs) {
            dcHostCount[$2]++;
        } else {
            dcHostCount[$2] = 0;
        };
        dcs[$2] = $2;
        hosts[$2, dcHostCount[$2]] = $1;
    }END{
        dcCount = asorti(dcs);
        for (i = 0; i < count; i++) {
            dc = dcs[(i % dcCount) + 1];
            ptr=int(perDcPtr[dc]++);
            print hosts[dc, ptr];
        }
    }'
}

CONSUMER_HOSTS=$(consumer_hostlist $CONSUMER_GROUP)
if [ $? -ne 0 ]
then
    >&2 echo "Can't obtain hostlist for consumer groups $CONSUMER_GROUP"
    exit 1
fi

for ((i = 0; i < $CONSUME_COUNT; i++))
do
    generate_map $i;
done

