package ru.yandex.mail.search.staff;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class Person implements JsonValue {
    private final String login;
    private final String email;
    private final String language;
    private final Name ruName;
    private final Name enName;
    private final Long messageId;
    private final Long uid;
    private final boolean dismissed;

    //CSOFF: ParameterNumber
    public Person(
        final String login,
        final Long messageId,
        final Long uid,
        final Name ruName,
        final Name enName,
        final String language,
        final boolean dismissed)
    {
        this.login = login;
        this.language = language;
        this.messageId = messageId;
        this.ruName = ruName;
        this.enName = enName;
        this.dismissed = dismissed;
        this.uid = uid;

        this.email = login + "@yandex-team.ru";
    }
    //CSON: ParameterNumber

    public String login() {
        return login;
    }

    public String email() {
        return email;
    }

    public Name ruName() {
        return ruName;
    }

    public Name enName() {
        return enName;
    }

    public boolean dismissed() {
        return dismissed;
    }

    public Long messageId() {
        return messageId;
    }

    public Long uid() {
        return uid;
    }

    public String language() {
        return language;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("url");
        // Url supposed to be primary key
        // making it unique
        // concatenating here not supposed to be too heavy
        writer.value(StaffIndexFields.url(String.valueOf(uid)));

        writer.key(StaffIndexFields.LOGIN);
        writer.value(login());

        writer.key(StaffIndexFields.EMAIL);
        writer.value(email());

        writer.key(StaffIndexFields.FIRST_NAME_RU);
        writer.value(ruName().firstName());

        writer.key(StaffIndexFields.LAST_NAME_RU);
        writer.value(ruName().lastName());

        writer.key(StaffIndexFields.FIRST_NAME_EN);
        writer.value(enName().firstName());

        writer.key(StaffIndexFields.LAST_NAME_EN);
        writer.value(enName().lastName());

        writer.key(StaffIndexFields.UID);
        writer.value(uid());

        writer.key(StaffIndexFields.DISMISSED);
        writer.value(dismissed());

        writer.key(StaffIndexFields.LANGUAGE);
        writer.value(language());
    }
}
