package ru.yandex.mail.search.staff;

import ru.yandex.util.string.StringUtils;

public final class StaffIndexFields {
    public static final String STAFF = "staff";
    public static final String LOGIN = STAFF + "_login";
    public static final String RU_LANG = "ru";
    public static final String EN_LANG = "en";

    public static final String FIRST_NAME = STAFF + "_first_name";
    public static final String FIRST_NAME_RU = FIRST_NAME + '_' + RU_LANG;
    public static final String FIRST_NAME_EN = FIRST_NAME + '_' + EN_LANG;
    public static final String LAST_NAME = STAFF + "_last_name";
    public static final String LAST_NAME_RU = LAST_NAME + '_' + RU_LANG;
    public static final String LAST_NAME_EN = LAST_NAME + '_' + EN_LANG;

    public static final String EMAIL = STAFF + "_email";
    public static final String UID = STAFF + "_uid";
    public static final String LANGUAGE = STAFF + "_language";
    public static final String DISMISSED = STAFF + "_dismissed";

    private StaffIndexFields() {
    }

    public static String url(final String prefix) {
        return StringUtils.concat("staff_", prefix);
    }
}
