package ru.yandex.mail.search.staff.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableStaffConsumerConfig
    extends ImmutableHttpProxyConfig
    implements StaffConsumerConfig
{
    private final int checkInterval;
    private final String token;
    private final ImmutableHttpHostConfig producerConfig;
    private final String service;
    private final long lockTimeout;
    private final ImmutableURIConfig staffClientConfig;
    private final String producerName;

    public ImmutableStaffConsumerConfig(
        final StaffConsumerConfig config)
        throws ConfigException
    {
        super(config);

        this.producerName = config.producerName();
        this.checkInterval = config.checkInterval();
        this.token = config.token();
        this.service = config.service();
        this.lockTimeout = config.lockTimeout();
        this.staffClientConfig =
            new ImmutableURIConfig(
                config.staffClientConfig());
        this.producerConfig =
            new ImmutableHttpHostConfig(config.producerConfig());
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    @Override
    public String token() {
        return token;
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public long lockTimeout() {
        return lockTimeout;
    }

    @Override
    public ImmutableURIConfig staffClientConfig() {
        return staffClientConfig;
    }

    @Override
    public String producerName() {
        return producerName;
    }
}
