package ru.yandex.mail.search.staff.config;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.parser.config.IniConfig;

public class StaffConsumerConfigBuilder
    extends AbstractStaffConsumerConfigBuilder<StaffConsumerConfigBuilder>
{
    public StaffConsumerConfigBuilder(
        final StaffConsumerConfig config)
    {
        super(config);
    }

    public StaffConsumerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, StaffConsumerConfigDefaults.INSTANCE);
    }

    public StaffConsumerConfigBuilder(
        final IniConfig config,
        final StaffConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public StaffConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableStaffConsumerConfig build() throws ConfigException {
        return new ImmutableStaffConsumerConfig(this);
    }
}
