package ru.yandex.mail.search.staff.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;

import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class StaffConsumerConfigDefaults
    extends HttpProxyConfigDefaults
    implements StaffConsumerConfig
{
    public static final StaffConsumerConfigDefaults INSTANCE =
        new StaffConsumerConfigDefaults();

    // 10 minutes
    private static final int DEFAULT_CHECK_INTERVAL = 300000;
    private static final int DEFAULT_LOCK_TIMEOUT = 600000;

    @Override
    public int checkInterval() {
        return DEFAULT_CHECK_INTERVAL;
    }

    @Override
    public String token() {
        return null;
    }

    @Override
    public HttpHostConfig producerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String service() {
        return "corp_change_log";
    }

    @Override
    public long lockTimeout() {
        return DEFAULT_LOCK_TIMEOUT;
    }

    @Override
    public URIConfig staffClientConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public String producerName() {
        return "staff-consumer";
    }
}
