package ru.yandex.mail.search.staff.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;

import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.StringCollectorsFactory;

import ru.yandex.mail.search.staff.Name;
import ru.yandex.mail.search.staff.Person;
import ru.yandex.mail.search.staff.Persons;

public class PersonsConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Persons>
{
    private static final String RU = "ru";
    private static final String EN = "en";

    public PersonsConsumer(final HttpEntity entity) throws HttpException {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected Persons buildResult(
        final HttpContext context,
        final JsonObject rootObj)
        throws Exception
    {
        JsonMap root = rootObj.asMap();
        JsonMap links = root.getMap("links");
        String next = links.getString("next", null);
        int limit = root.getInt("limit");
        int pageCount = root.getInt("pages");

        List<Person> persons = new ArrayList<>(limit);
        JsonList results = root.getList("result");
        for (JsonObject itemObj: results) {
            JsonMap item = itemObj.asMap();
            String language =
                item.getMap("language").getString("native").trim()
                    .toLowerCase(Locale.ROOT);

            JsonMap official = item.getMap("official");
            if (official.getBoolean("is_robot", false)) {
                continue;
            }

            JsonMap name = item.getMap("name");

            JsonMap first = name.getMap("first");
            JsonMap last = name.getMap("last");

            persons.add(
                    new Person(
                        item.getString("login"),
                        item.getMap("_meta").getLong("message_id"),
                        item.getLong("uid"),
                        new Name(first.getString(RU), last.getString(RU)),
                        new Name(first.getString(EN), last.getString(EN)),
                        language,
                        official.getBoolean("is_dismissed", false)));
        }

        return new Persons(persons, next, pageCount);
    }
}
