package ru.yandex.mail.search.staff.consumer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

import ru.yandex.mail.search.staff.Persons;

public enum PersonsConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Persons>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<Persons> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public PersonsConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new PersonsConsumer(response.getEntity());
    }
}
