package ru.yandex.mail.search.staff.consumer;

public class SingleMessageUpdateTaskCallback
    implements StaffUpdateTaskCallback
{
    private final StaffUpdateTaskCallback wrapped;
    private final StaffConsumer consumer;
    private final Long messageId;

    public SingleMessageUpdateTaskCallback(
        final StaffConsumer consumer,
        final StaffUpdateTaskCallback wrapped)
    {
        this.consumer = consumer;
        this.wrapped = wrapped;
        this.messageId = wrapped.startMessageId();
    }

    @Override
    public Long startMessageId() {
        return messageId;
    }

    @Override
    public String lockId() {
        return wrapped.lockId();
    }

    @Override
    public void completed(final Object o) {
        consumer.logger().info(
            "Single messageId consume completed, continue further");
        consumer.load(wrapped, StaffConsumer.GREATER_OPERATION, messageId);
    }

    @Override
    public void failed(final Exception e) {
        wrapped.failed(e);
    }

    @Override
    public void cancelled() {
        wrapped.cancelled();
    }

    @Override
    public void updateMessageId(final long mId) {
        wrapped.updateMessageId(mId);
    }
}
