package ru.yandex.mail.search.staff.consumer;

import java.io.IOException;

import java.util.Timer;

import ru.yandex.http.proxy.HttpProxy;

import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.mail.search.staff.config.ImmutableStaffConsumerConfig;

public class StaffConsumerServer
    extends HttpProxy<ImmutableStaffConsumerConfig>
{
    private final AsyncClient staffClient;
    private final AsyncClient producerClient;

    private final Timer timer;
    private final StaffConsumer staffConsumer;

    public StaffConsumerServer(
        final ImmutableStaffConsumerConfig config)
        throws IOException
    {
        super(config);

        this.staffClient =
            client("StaffClient", config.staffClientConfig());
        this.producerClient =
            client("ProducerClient", config.producerConfig());

        this.timer = new Timer("StaffConsumerScheduler");
        this.staffConsumer = new StaffConsumer(this);
    }

    @Override
    public void start() throws IOException {
        super.start();

        this.timer.schedule(
            staffConsumer,
            config.checkInterval(),
            config.checkInterval());
    }

    @Override
    public void close() throws IOException {
        this.timer.cancel();

        super.close();
    }

    public AsyncClient staffClient() {
        return staffClient;
    }

    public AsyncClient producerClient() {
        return producerClient;
    }
}
