package ru.yandex.search.proxy.tts;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractTTSProxyConfigBuilder
    <T extends AbstractUniversalSearchProxyConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements TTSProxyConfig
{
    private String service;

    protected AbstractTTSProxyConfigBuilder(
        final TTSProxyConfig config)
    {
        super(config);
        this.service = config.service();
    }

    protected AbstractTTSProxyConfigBuilder(
        final IniConfig config,
        final TTSProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.service = config.getString("service", defaults.service());
    }

    @Override
    public String service() {
        return service;
    }

    public T service(final String service) {
        this.service = service;
        return self();
    }
}
