package ru.yandex.search.proxy.tts;

import java.io.IOException;

import java.util.Collections;
import java.util.List;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;

import ru.yandex.client.producer.ProducerClient;

import ru.yandex.collection.LazyList;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;

import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;

import ru.yandex.search.prefix.LongPrefix;

import ru.yandex.search.tts.gorgophone.RelationshipRecordContext;

public class AddRelationshipRecordHandler implements ProxyRequestHandler {
    private static int hostsRotate = 0;
    private final TTSProxy server;

    public AddRelationshipRecordHandler(final TTSProxy server) {
        this.server = server;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        if (session.request() instanceof HttpEntityEnclosingRequest) {
            handleBatch(session);
        } else {
            handleSingleRecord(session);
        }
    }

    private void handleSingleRecord(final ProxySession session)
        throws BadRequestException
    {
        final String service = server.config().service();
        final RelationshipRecordContext record =
            new RelationshipRecordContext(session.params());

        final User user = new User(service, new LongPrefix(record.prefix()));
        final long prefix = record.prefix();
        final int shard =
            Math.abs((int) (record.prefix() % SearchMap.SHARDS_COUNT));

        List<HttpHost> hosts;
        HttpHost producer = server.config().producerClientConfig().host();
        if (producer != null) {
            hosts = Collections.singletonList(producer);
        } else {
            final SearchMapShard searchMapShard =
                server.searchMap().apply(user);
            hosts = new LazyList<>(searchMapShard.zk(), x -> x.host());
            ((LazyList) hosts).rotate(hostsRotate++);
        }
        ProducerClient client =
            server.producerClient().adjust(session.context());
        client.execute(
            hosts,
            new BasicAsyncRequestProducerGenerator(
                record.uri("/AddRelationshipRecord?service=" + service
                    + "&prefix=" + prefix + "&shard=" + shard)),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new ResponseCallback(session));
    }

    private void handleBatch(final ProxySession session) {
        session.response(HttpStatus.SC_NOT_IMPLEMENTED);
    }

    private static class ResponseCallback
        extends AbstractProxySessionCallback<Void>
    {
        ResponseCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Void v) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
