package ru.yandex.search.proxy.tts;

import java.io.IOException;

import ru.yandex.collection.Pattern;

import ru.yandex.search.proxy.universal.UniversalSearchProxy;

public class TTSProxy extends UniversalSearchProxy<ImmutableTTSProxyConfig> {
    public static final String SERVICE = "tts";

    private final ImmutableTTSProxyConfig config;

    public TTSProxy(
        final ImmutableTTSProxyConfig config)
        throws IOException
    {
        super(config);
        this.config = config;

        register(
            new Pattern<>("/AddEntityRecord", false),
            new AddEntityRecordHandler(this));
        register(
            new Pattern<>("/add-entity-record", false),
            new AddEntityRecordHandler(this));

        register(
            new Pattern<>("/AddPropertyRecord", false),
            new AddPropertyRecordHandler(this));
        register(
            new Pattern<>("/add-property-record", false),
            new AddPropertyRecordHandler(this));

        register(
            new Pattern<>("/AddRelationshipRecord", false),
            new AddRelationshipRecordHandler(this));
        register(
            new Pattern<>("/add-relationship-record", false),
            new AddRelationshipRecordHandler(this));
    }
}
