package ru.yandex.search.proxy.tts;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class TTSProxyConfigBuilder
    extends AbstractTTSProxyConfigBuilder
    <TTSProxyConfigBuilder>
{
    public TTSProxyConfigBuilder() {
        super(TTSProxyConfigDefaults.INSTANCE);
    }

    public TTSProxyConfigBuilder(
        final TTSProxyConfig config)
    {
        super(config);
    }

    public TTSProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, TTSProxyConfigDefaults.INSTANCE);
    }

    public TTSProxyConfigBuilder(
        final IniConfig config,
        final TTSProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public TTSProxyConfigBuilder self() {
        return this;
    }

    public ImmutableTTSProxyConfig build() throws ConfigException {
        return new ImmutableTTSProxyConfig(this);
    }
}
