package ru.yandex.search.mail.xavier;

import org.apache.http.HttpException;
import ru.yandex.json.parser.JsonException;

public class CacheInvalidateHandler extends XavierSkipHandler {
    public static final CacheInvalidateHandler INSTANCE =
        new CacheInvalidateHandler();

    @Override
    public void handle(final XavierContext context)
        throws HttpException, JsonException
    {
        if (context.xavier().config().cacheUnreadStats()) {
            context.xavier().unreadCountCache()
                .remove(context.prefix().prefix());

            context.session().logger().info(
                "Cache cleaned for " + context.prefix().prefix());
        }

        super.handle(context);
    }
}
