package ru.yandex.search.mail.xavier;

import java.net.URISyntaxException;

import java.nio.charset.CharacterCodingException;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dbfields.ChangeType;

import ru.yandex.function.StringBuilderProcessorAdapter;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncGetURIRequestProducerSupplier;

import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;

import ru.yandex.json.dom.JsonObject;

import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;

public class FilterSearchStep {
    public void fetch(
        final XavierContext context,
        final FutureCallback<JsonObject> callback)
    {
        Xavier xavier = context.xavier();

        StringBuilder filterSearchUri =
            new StringBuilder(
                xavier.config().filterSearchConfig().uri().toString());
        filterSearchUri.append("&order=default");
        filterSearchUri.append("&full_folders_and_labels=1");
        filterSearchUri.append("&uid=");
        filterSearchUri.append(context.user().prefix());

        filterSearchUri.append("&lcn=");
        if (context.changeType() == ChangeType.FIELDS_UPDATE) {
            filterSearchUri.append(-1);
            filterSearchUri.append("&zoo-queue-id=");
            filterSearchUri.append(context.queueId());
        } else {
            filterSearchUri.append(context.lcn());
        }

        if (context.operationId() != null) {
            filterSearchUri.append("&operation-id=");
            filterSearchUri.append(
                context.operationId().toString());
        }

        try {
            if (context.shard() != null) {
                filterSearchUri.append("&pgshard=");
                PctEncoder encoder = new PctEncoder(PctEncodingRule.QUERY);
                encoder.process(context.shard().toCharArray());
                encoder.processWith(
                    new StringBuilderProcessorAdapter(filterSearchUri));
            }

            for (String mid : context.mids()) {
                filterSearchUri.append("&mids=");
                filterSearchUri.append(mid);
            }

            String uri = new String(filterSearchUri);

            context.session().logger().info("FilterSearch " + uri);

            AsyncClient client = xavier.filterSearchClient();
            client.execute(
                new AsyncGetURIRequestProducerSupplier(uri),
                JsonAsyncTypesafeDomConsumerFactory.INTERNING_OK,
                context.session().listener()
                    .createContextGeneratorFor(client),
                callback);
        } catch (URISyntaxException | CharacterCodingException e) {
            context.callback().failed(e);
        }
    }
}
