package ru.yandex.search.mail.xavier;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class LagsStater implements Stater {
    private static final int[] BOUNDARIES =
        {10, 25, 50, 75, 100, 150, 300, 600, 1200, 3000, 6000};
    private static final String MS_AMMM = "-ms_ammm";

    private final Iterable<Long> data;
    private final String prefix;

    public LagsStater(final Iterable<Long> data, final String prefix) {
        this.data = data;
        this.prefix = prefix;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int count = 0;
        int[] lagDistribution = new int[BOUNDARIES.length + 1];
        loopTimes:
        for (Long lag: data) {
            ++count;
            for (int boundaryNumber = 0;
                    boundaryNumber < BOUNDARIES.length;
                    ++boundaryNumber)
            {
                if (lag < BOUNDARIES[boundaryNumber]) {
                    ++lagDistribution[boundaryNumber];
                    continue loopTimes;
                }
            }
            ++lagDistribution[BOUNDARIES.length];
        }
        for (int i = 0; i < BOUNDARIES.length; ++i) {
            statsConsumer.stat(
                prefix + "-time-less-" + BOUNDARIES[i] + MS_AMMM,
                lagDistribution[i]);
        }
        statsConsumer.stat(
            prefix + "-time-greater-"
            + BOUNDARIES[BOUNDARIES.length - 1] + MS_AMMM,
            lagDistribution[BOUNDARIES.length]);
        statsConsumer.stat(prefix + "-times-counter_ammm", count);
    }
}
