package ru.yandex.search.mail.xavier;

import java.util.concurrent.TimeUnit;

import ru.yandex.http.util.BadRequestException;

public final class StaleChecker {
    private static final double THOUSAND = 1000.0;

    private StaleChecker() {
    }

    public static boolean isStaleNotify(final XavierContext context)
        throws BadRequestException
    {
        double now = System.currentTimeMillis() / THOUSAND;

        double opDate;
        if (context.operationDate() != null) {
            opDate = context.operationDate();
        } else {
            opDate = now;
        }

        double lagHours = TimeUnit.SECONDS.toHours((long) (now - opDate));
        if (lagHours > context.xavier().config().hoursSkipStaleRecords()) {
            context.session().logger().info(
                "Lag hours is " + lagHours + " skipping");
            return true;
        }

        return false;
    }
}
