package ru.yandex.search.mail.xavier;

import org.apache.http.HttpStatus;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

public class XavierCallback extends AbstractProxySessionCallback<Object> {
    private static final int THOUSAND = 1000;

    private final XavierContext context;

    public XavierCallback(
        final ProxySession session,
        final XavierContext context)
    {
        super(session);

        this.context = context;
    }

    @Override
    public void completed(final Object o) {
        session.response(HttpStatus.SC_OK);
        if (context.operationDate() != null) {
            long lag = (long) (System.currentTimeMillis()
                - context.operationDate() * THOUSAND);
            context.session().logger().info("Lag " + lag);
            context.xavier().staters().xavierNotifyLag().accept(lag);
        }
    }

    public void notReady() {
        session.response(
            HttpStatus.SC_INTERNAL_SERVER_ERROR,
            "No backend processed " + context.queueId() + " yet");
    }
}
