package ru.yandex.search.mail.xavier;

import ru.yandex.dispatcher.consumer.ConsumerServer;

import ru.yandex.http.util.server.DefaultHttpServerFactory;

import ru.yandex.util.build.SuppressFBWarnings;

public final class XavierMeta {
    private static final String CONFIG = "-config";

    private XavierMeta() {
    }

    @SuppressFBWarnings("DM_EXIT")
    public static void main(final String[] args) {
        if (args.length < 2) {
            System.out.println(
                "Usage: ru.yandex.search.mail.xavier.XavierMeta"
                    + "consumer.conf xavier.conf");
            System.exit(-1);
        }

        final String consumerConfig = args[0];
        final String xavierConfig = args[1];

        Thread consumer = new Thread("consumer-main") {
            @Override
            @SuppressFBWarnings("DM_EXIT")
            public void run() {
                try {
                    ConsumerServer.main(CONFIG, consumerConfig);
                } catch (Exception e) {
                    System.err.println("consumer failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };

        consumer.start();

        Thread xavier = new Thread("xavier-main") {
            @Override
            @SuppressFBWarnings("DM_EXIT")
            public void run() {
                try {
                    Xavier.main(
                        new DefaultHttpServerFactory<>(Xavier.class),
                        xavierConfig);
                } catch (Exception e) {
                    System.err.println("Xavier failed to start");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        };

        xavier.start();
    }
}
