package ru.yandex.search.mail.xavier;

import ru.yandex.concurrent.TimeFrameQueue;

import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.MaxAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class XavierStats {
    private final TimeFrameQueue<Long> userTypeChange;
    private final TimeFrameQueue<Long> xavierNotifyLag;

    public XavierStats(final Xavier xavier) {
        userTypeChange =
            new TimeFrameQueue<>(xavier.config().metricsTimeFrame());

        xavier.registerStater(
            new PassiveStaterAdapter<>(
                userTypeChange,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "user-type-lag-max_axxx",
                        new MaxAggregatorFactory(0)
                    ),
                    new NamedStatsAggregatorFactory<>(
                        "user-type-lag_ammm",
                        IntegralSumAggregatorFactory.INSTANCE
                    ))));

        xavierNotifyLag =
            new TimeFrameQueue<>(xavier.config().metricsTimeFrame());

        xavier.registerStater(
            new PassiveStaterAdapter<>(
                xavierNotifyLag,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "notify-lag-max_axxx",
                        new MaxAggregatorFactory(0)
                    ),
                    new NamedStatsAggregatorFactory<>(
                        "notify-lag_ammm",
                        IntegralSumAggregatorFactory.INSTANCE
                    ))));
        xavier.registerStater(new LagsStater(xavierNotifyLag, "notify-lag"));
    }

    public TimeFrameQueue<Long> userTypeChange() {
        return userTypeChange;
    }

    public TimeFrameQueue<Long> xavierNotifyLag() {
        return xavierNotifyLag;
    }
}
