package ru.yandex.search.mail.xavier;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.xavier.config.XivaConfig;
import ru.yandex.search.mail.xavier.config.XivaConfigDefaults;

public class XivaConfigBuilder implements XivaConfig {
    private static final String TOKEN = "token";
    private static final String LIST = "list";
    private static final String HOST = "host";
    private static final String NOTIFY = "notify";

    private HttpTargetConfigBuilder notifyClientConfig;
    private HttpTargetConfigBuilder listClientConfig;

    private HttpHost host;
    private String notifyToken;
    private String listToken;

    public XivaConfigBuilder() {
        this(XivaConfigDefaults.INSTANCE);
    }

    public XivaConfigBuilder(final XivaConfig config) {
        host(config.host());
        notifyToken(config.notifyToken());
        listToken(config.listToken());

        listClientConfig(config.listClientConfig());
        notifyClientConfig(config.notifyClientConfig());
    }

    public XivaConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, XivaConfigDefaults.INSTANCE);
    }

    public XivaConfigBuilder(
        final IniConfig config,
        final XivaConfig defaults) throws ConfigException
    {
        IniConfig listSection = config.section(LIST);
        this.listClientConfig =
            new HttpTargetConfigBuilder(
                listSection,
                defaults.listClientConfig());
        IniConfig notifySection = config.section(NOTIFY);

        this.notifyClientConfig =
            new HttpTargetConfigBuilder(
                notifySection,
                defaults.notifyClientConfig());

        this.notifyToken =
            notifySection.getString(
                TOKEN,
                defaults.notifyToken());

        this.host =
            config.get(HOST, defaults.host(), HttpHostParser.INSTANCE);

        this.listToken = listSection.getString(TOKEN, defaults.listToken());
    }

    @Override
    public String notifyToken() {
        return notifyToken;
    }

    public XivaConfigBuilder notifyToken(final String token) {
        this.notifyToken = token;
        return this;
    }

    @Override
    public String listToken() {
        return listToken;
    }

    public XivaConfigBuilder listToken(final String listToken) {
        this.listToken = listToken;
        return this;
    }

    @Override
    public HttpTargetConfigBuilder notifyClientConfig() {
        return notifyClientConfig;
    }

    public XivaConfigBuilder notifyClientConfig(
        final HttpTargetConfig notifyClientConfig)
    {
        this.notifyClientConfig =
            new HttpTargetConfigBuilder(notifyClientConfig);
        return this;
    }

    @Override
    public HttpTargetConfigBuilder listClientConfig() {
        return listClientConfig;
    }

    public XivaConfigBuilder listClientConfig(
        final HttpTargetConfig listClientConfig)
    {
        this.listClientConfig = new HttpTargetConfigBuilder(listClientConfig);
        return this;
    }

    @Override
    public HttpHost host() {
        return host;
    }

    public XivaConfigBuilder host(final HttpHost host) {
        this.host = host;
        return this;
    }
}
