package ru.yandex.search.mail.xavier;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;

import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;

import ru.yandex.json.dom.BasicContainerFactory;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.StringCollectorsFactory;

public class XivaListConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Boolean>
{
    public XivaListConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected Boolean buildResult(
        final HttpContext context,
        final JsonObject root)
        throws Exception
    {
        JsonList subscribers = root.asList();
        boolean status = false;
        for (JsonObject subsObj: subscribers) {
            JsonMap subs = subsObj.asMap();
            String platform = subs.getString("platform", null);
            String client = subs.getString("client", null);

            if ("imap".equalsIgnoreCase(client)
                || "yabrowser".equalsIgnoreCase(client))
            {
                continue;
            }

            if ("apns".equalsIgnoreCase(platform)
                || "gcm".equalsIgnoreCase(platform))
            {
                continue;
            }

            status = true;
            break;
        }

        return status;
    }
}
