package ru.yandex.search.mail.xavier;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum XivaListConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Boolean>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<Boolean> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public HttpAsyncResponseConsumer<Boolean> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new XivaListConsumer(response.getEntity());
    }
}
