package ru.yandex.search.mail.xavier.config;

import java.util.Collections;
import java.util.Set;

import ru.yandex.client.producer.ImmutableProducerClientConfig;

import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;

public class ImmutableXavierConfig
    extends ImmutableHttpProxyConfig
    implements XavierConfig
{
    private final ImmutableFilterSearchConfig filterSearchConfig;
    private final ImmutableXivaConfig xivaConfig;
    private final ImmutableHttpHostConfig proxyConfig;
    private final ImmutableHttpTargetConfig searchClientConfig;
    private final ImmutableProducerClientConfig producerClientConfig;
    private final ImmutableSearchMapConfig searchMapConfig;
    private final String pgQueue;
    private final String indexUri;
    private final int usertypeBatchSize;
    private final int hoursSkipStaleRecords;
    private final Set<String> categories;
    private final int unreadStatCacheSize;
    private final boolean cacheUnreadStats;

    public ImmutableXavierConfig(final XavierConfig config)
        throws ConfigException
    {
        super(config);

        this.filterSearchConfig =
            new ImmutableFilterSearchConfig(config.filterSearchConfig());
        this.xivaConfig = new ImmutableXivaConfig(config.xivaConfig());
        this.proxyConfig = new ImmutableHttpHostConfig(config.proxyConfig());
        this.searchClientConfig =
            new ImmutableHttpTargetConfig(config.searchClientConfig());
        this.producerClientConfig =
            new ImmutableProducerClientConfig(config.producerConfig());

        this.pgQueue = config.pgQueue();
        this.indexUri = config.indexUri();
        this.usertypeBatchSize = config.usertypeBatchSize();
        this.categories = Collections.unmodifiableSet(config.categories());
        this.searchMapConfig =
            new ImmutableSearchMapConfig(config.searchMapConfig());
        this.hoursSkipStaleRecords = config.hoursSkipStaleRecords();
        this.unreadStatCacheSize = config.unreadStatCacheSize();
        this.cacheUnreadStats = config.cacheUnreadStats();
    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public String pgQueue() {
        return pgQueue;
    }

    @Override
    public String indexUri() {
        return indexUri;
    }

    @Override
    public int usertypeBatchSize() {
        return usertypeBatchSize;
    }

    @Override
    public ImmutableProducerClientConfig producerConfig() {
        return producerClientConfig;
    }

    @Override
    public Set<String> categories() {
        return categories;
    }

    @Override
    public ImmutableXivaConfig xivaConfig() {
        return xivaConfig;
    }

    @Override
    public ImmutableHttpHostConfig proxyConfig() {
        return proxyConfig;
    }

    @Override
    public ImmutableFilterSearchConfig filterSearchConfig() {
        return filterSearchConfig;
    }

    @Override
    public ImmutableHttpTargetConfig searchClientConfig() {
        return searchClientConfig;
    }

    @Override
    public int hoursSkipStaleRecords() {
        return hoursSkipStaleRecords;
    }

    @Override
    public int unreadStatCacheSize() {
        return unreadStatCacheSize;
    }

    @Override
    public boolean cacheUnreadStats() {
        return cacheUnreadStats;
    }
}
