package ru.yandex.search.mail.xavier.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableXivaConfig implements XivaConfig {
    private ImmutableHttpTargetConfig notifyClientConfig;
    private ImmutableHttpTargetConfig listClientConfig;

    private final HttpHost host;
    private final String notifyToken;
    private final String listToken;

    public ImmutableXivaConfig(final XivaConfig config) throws ConfigException {
        this.notifyClientConfig =
            new ImmutableHttpTargetConfig(config.notifyClientConfig());
        this.listClientConfig =
            new ImmutableHttpTargetConfig(config.listClientConfig());

        this.host = config.host();
        if (host == null) {
            throw new ConfigException("Host is not set");
        }

        this.notifyToken = config.notifyToken();
        if (config.listToken() != null && !config.listToken().isEmpty()) {
            this.listToken = config.listToken();
        } else {
            this.listToken = config.notifyToken();
        }
    }

    @Override
    public String notifyToken() {
        return notifyToken;
    }

    @Override
    public String listToken() {
        return listToken;
    }

    @Override
    public ImmutableHttpTargetConfig notifyClientConfig() {
        return notifyClientConfig;
    }

    @Override
    public ImmutableHttpTargetConfig listClientConfig() {
        return listClientConfig;
    }

    @Override
    public HttpHost host() {
        return host;
    }
}
