package ru.yandex.search.mail.xavier.config;

import java.util.Set;

import ru.yandex.client.producer.ProducerClientConfig;

import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;

import ru.yandex.http.util.server.HttpProxyConfig;

import ru.yandex.parser.searchmap.SearchMapConfig;

public interface XavierConfig extends HttpProxyConfig {
    String pgQueue();

    String indexUri();

    int usertypeBatchSize();

    ProducerClientConfig producerConfig();

    Set<String> categories();

    XivaConfig xivaConfig();

    HttpHostConfig proxyConfig();

    HttpTargetConfig searchClientConfig();

    FilterSearchConfig filterSearchConfig();

    SearchMapConfig searchMapConfig();

    /**
     * Minimal age of notify to skip it
     */
    int hoursSkipStaleRecords();

    int unreadStatCacheSize();

    boolean cacheUnreadStats();
}
