package ru.yandex.search.mail.xavier.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class XavierConfigBuilder
    extends AbstractXavierConfigBuilder<XavierConfigBuilder>
{
    public XavierConfigBuilder() {
        super(XavierConfigDefaults.INSTANCE);
    }

    public XavierConfigBuilder(final XavierConfig config) {
        super(config);
    }

    public XavierConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, XavierConfigDefaults.INSTANCE);
    }

    @Override
    public XavierConfigBuilder self() {
        return this;
    }

    public ImmutableXavierConfig build() throws ConfigException {
        return new ImmutableXavierConfig(this);
    }
}
