package ru.yandex.search.mail.xavier.config;

import java.util.Collections;
import java.util.Set;

import ru.yandex.client.producer.ProducerClientConfig;
import ru.yandex.client.producer.ProducerClientConfigDefaults;

import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;

import ru.yandex.http.util.server.HttpProxyConfigDefaults;

import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigDefaults;

public class XavierConfigDefaults
    extends HttpProxyConfigDefaults
    implements XavierConfig
{
    public static final XavierConfigDefaults INSTANCE =
        new XavierConfigDefaults();

    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final int DEFAULT_UNREAD_CACHE_SIZE = 10000000;
    private static final int DEFAULT_SKIP_RECORDS_TIME = 12;

    protected XavierConfigDefaults() {
    }

    @Override
    public String pgQueue() {
        return "change_log";
    }

    @Override
    public String indexUri() {
        return null;
    }

    @Override
    public int usertypeBatchSize() {
        return DEFAULT_BATCH_SIZE;
    }

    @Override
    public ProducerClientConfig producerConfig() {
        return ProducerClientConfigDefaults.INSTANCE;
    }

    @Override
    public Set<String> categories() {
        return Collections.emptySet();
    }

    @Override
    public XivaConfig xivaConfig() {
        return XivaConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig proxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig searchClientConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public FilterSearchConfig filterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return SearchMapConfigDefaults.INSTANCE;
    }

    @Override
    public int hoursSkipStaleRecords() {
        return DEFAULT_SKIP_RECORDS_TIME;
    }

    @Override
    public int unreadStatCacheSize() {
        return DEFAULT_UNREAD_CACHE_SIZE;
    }

    @Override
    public boolean cacheUnreadStats() {
        return true;
    }
}
