package ru.yandex.search.mail.xavier.move;

import java.io.IOException;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import java.util.function.Function;

import org.apache.http.entity.ContentType;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.JsonException;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.mail.xavier.XavierContext;

import ru.yandex.search.mail.xavier.store.StoreUnreadCountCallback;
import ru.yandex.search.mail.xavier.store.XavierData;

public class MoveCallback extends StoreUnreadCountCallback {
    public MoveCallback(final XavierContext context) {
        super(context);
    }

    // CSOFF: MultipleStringLiterals
    // CSOFF: ParameterNumber
    private void message(
        final Map.Entry<String, List<JsonObject>> envelopeEntry,
        final JsonWriter writer,
        final Map<String, Integer> counters,
        final Map<String, List<String>> categories)
        throws IOException, JsonException
    {
        writer.startObject();
        writer.key("fid");
        writer.value(envelopeEntry.getKey());
        writer.key("method_id");
        writer.value("");
        writer.key("mid");
        writer.value(context.mids());

        writer.key("lcn");
        writer.value(context.lcn());
        writer.key("session_key");
        writer.value("");

        writer.key("operation");
        writer.value("move mails");

        writer.key("categories");
        writer.value(categories);

        writer.key("counters");
        writer.startObject();
        for (Map.Entry<String, Integer> entry : counters.entrySet()) {
            writer.key(entry.getKey());
            writer.startObject();
            writer.key("unread");
            writer.value(entry.getValue());
            writer.endObject();
        }

        writer.endObject();
        writer.endObject();
    }

    public BasicAsyncRequestProducerGenerator buildRequest(
        final Map.Entry<String, List<JsonObject>> envelopeEntry,
        final Map<String, Integer> counters,
        final Map<String, List<String>> categories)
        throws IOException, JsonException, BadRequestException
    {
        QueryConstructor qc = new QueryConstructor("/v2/send?");
        qc.append("ttl", 0);
        qc.append(
            "token",
            context.xavier().config().xivaConfig().notifyToken());
        qc.append("user", context.prefix().toString());
        qc.append("event", "msearch_move");

        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = JsonWriter.create(sbWriter)) {
            writer.startObject();
            writer.key("payload");
            writer.startObject();
            writer.key("message");
            message(envelopeEntry, writer, counters, categories);
            writer.key("operation");
            writer.value("unsupported");
            writer.key("service");
            writer.value("msearch");
            writer.key("uid");
            writer.value(context.user().prefix().toString());
            writer.key("session_key");
            writer.value("");
            writer.key("tags");
            writer.startArray();
            writer.endArray();
            writer.key("version");
            writer.value("1");
            writer.key("raw_data");
            writer.startObject();
            writer.key("uid");
            writer.value(context.user().prefix().toString());
            writer.key("envelopes");
            writer.startArray();
            for (JsonObject envelope: envelopeEntry.getValue()) {
                writer.value(envelope);
            }
            writer.endArray();
            writer.endObject();
            writer.endObject();
            writer.endObject();
        }

        context.session().logger().info(
            "Xiva " + qc.toString() + " data\n" + sbWriter.toString());

        return new BasicAsyncRequestProducerGenerator(
            qc.toString(),
            sbWriter.toString(),
            ContentType.APPLICATION_JSON);
    }
    // CSON: MultipleStringLiterals
    // CSON: ParameterNumber

    @Override
    protected void process(
        final AsyncClient client,
        final XavierData data)
        throws IOException, JsonException, BadRequestException
    {
        JsonList envelopesList = data.envelopes().get("envelopes").asList();
        if (envelopesList.size() <= 0) {
            context.callback().completed(null);
            return;
        }

        Function<String, List<JsonObject>> listFactory = x -> new ArrayList<>();
        Map<String, List<JsonObject>> fidMap = new LinkedHashMap<>();
        for (JsonObject jo: envelopesList) {
            fidMap.computeIfAbsent(
                jo.asMap().get("fid").asString(),
                listFactory).add(jo);
        }

        MultiFutureCallback<Void> mfcb =
            new MultiFutureCallback<>(new XivaCallback(context));

        for (Entry<String, List<JsonObject>> entry: fidMap.entrySet()) {
            context.session().logger().info(
                "Xiva request "
                    + buildRequest(entry, data.counters(), data.categories())
                    .toString());

            client.execute(
                context.xavier().config().xivaConfig().host(),
                buildRequest(entry, data.counters(), data.categories()),
                EmptyAsyncConsumerFactory.OK,
                context.session().listener().createContextGeneratorFor(
                    client),
                mfcb.newCallback());
        }

        mfcb.done();
    }

    private static final class XivaCallback
        extends AbstractFilterFutureCallback<List<Void>, Object>
    {
        private final XavierContext context;

        private XivaCallback(final XavierContext context) {
            super(context.callback());
            this.context = context;
        }

        @Override
        public void completed(final List<Void> o) {
            context.session().logger().info("Xiva notify sent");
            context.callback().completed(o);
        }
    }
}
