package ru.yandex.search.mail.xavier.move;

import java.util.List;

import org.apache.http.HttpException;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.client.producer.QueueHostInfo;

import ru.yandex.http.proxy.AbstractProxySessionCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.json.parser.JsonException;

import ru.yandex.search.mail.xavier.FilterSearchStep;
import ru.yandex.search.mail.xavier.StaleChecker;
import ru.yandex.search.mail.xavier.Xavier;
import ru.yandex.search.mail.xavier.XavierContext;
import ru.yandex.search.mail.xavier.XavierHandler;
import ru.yandex.search.mail.xavier.XivaListConsumerFactory;

import ru.yandex.search.mail.xavier.proxy.CategoriesFetchStep;
import ru.yandex.search.mail.xavier.proxy.UnreadCountStep;

import ru.yandex.search.mail.xavier.store.CachingFetchSession;
import ru.yandex.search.mail.xavier.store.CategoriesCallback;
import ru.yandex.search.mail.xavier.store.FetchSession;
import ru.yandex.search.mail.xavier.store.FilterSearchCallback;
import ru.yandex.search.mail.xavier.store.UnreadCountCallback;

import ru.yandex.search.mail.xavier.store.XavierData;

public class MoveXavierHandler implements XavierHandler {
    private final Xavier xavier;
    private final UnreadCountStep unreadCountStep;
    private final CategoriesFetchStep categoriesFetchStep;
    private final FilterSearchStep filterSearchStep;

    public MoveXavierHandler(final Xavier xavier) {
        this.xavier = xavier;
        this.unreadCountStep = new UnreadCountStep(xavier);
        this.categoriesFetchStep = new CategoriesFetchStep(xavier);
        this.filterSearchStep = new FilterSearchStep();
    }

    @Override
    public void handle(final XavierContext context)
        throws HttpException, JsonException
    {
        if (StaleChecker.isStaleNotify(context)) {
            context.callback().completed(null);
            return;
        }

        AsyncClient xivaClient =
            context.xavier().xivaListClient().adjust(
                context.session().context());
        BasicAsyncRequestProducerGenerator get =
            new BasicAsyncRequestProducerGenerator("/v2/list?service=mail&user="
                + context.prefix() + "&token="
                + context.xavier().config().xivaConfig().listToken());

        xivaClient.execute(
            context.xavier().config().xivaConfig().host(),
            get,
            XivaListConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(
                xivaClient),
            new XivaCheckCallback(context));
    }

    private final class XivaCheckCallback
        extends AbstractProxySessionCallback<Boolean>
    {
        private final XavierContext context;

        XivaCheckCallback(final XavierContext context) {
            super(context.session());
            this.context = context;
        }

        @Override
        public void completed(final Boolean online) {
            if (!online) {
                context.session().logger().info("User is offline, ignoring");
                context.xavier().unreadCountCache().remove(
                    context.prefix().prefix());
                context.callback().completed(null);
            } else {
                ProducerClient client =
                    xavier.producerClient().adjust(context.session().context());

                client.executeWithInfo(
                    context.user(),
                    context.session().listener().createContextGeneratorFor(
                        client),
                    new PositionCallback(context));
            }
        }
    }

    private final class PositionCallback
        extends AbstractFilterFutureCallback<List<QueueHostInfo>, Object>
    {
        private final XavierContext context;

        private PositionCallback(final XavierContext context) {
            super(context.callback());

            this.context = context;
        }

        @Override
        public void completed(final List<QueueHostInfo> hostInfos) {
            boolean indexed =
                hostInfos.stream()
                    .filter(hi -> hi.queueId() >= context.queueId())
                    .count() > 0;

            if (!indexed) {
                context.callback().notReady();
                return;
            }

            FutureCallback<XavierData> cb = new MoveCallback(context);
            FetchSession session;
            if (context.xavier().config().cacheUnreadStats()) {
                session = new CachingFetchSession(context, cb);
            } else {
                session = new FetchSession(cb);
            }

            unreadCountStep.fetch(
                context,
                new UnreadCountCallback(session));
            filterSearchStep.fetch(context, new FilterSearchCallback(session));
            categoriesFetchStep.fetch(context, new CategoriesCallback(session));
        }
    }
}
