package ru.yandex.search.mail.xavier.proxy;

import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dbfields.OracleFields;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.mail.xavier.Xavier;
import ru.yandex.search.mail.xavier.XavierContext;

public class CategoriesFetchStep {
    public CategoriesFetchStep(final Xavier xavier) {
    }

    public void fetch(
        final XavierContext context,
        final FutureCallback<Map<String, List<String>>> callback)
    {
        AsyncClient proxyClient =
            context.xavier().proxyClient().adjust(context.session().context());
        QueryConstructor qc =
            new QueryConstructor("/api/async/mail/tabs/category?");
        try {
            qc.append("uid", context.user().prefix().toString());
            qc.append(
                "mdb",
                context.session().params().getString(OracleFields.MDB));
            qc.append("position", String.valueOf(context.queueId()));

            for (String mid: context.mids()) {
                qc.append("mid", mid);
            }
        } catch (BadRequestException bre) {
            callback.failed(bre);
            return;
        }

        context.session().logger().info("Unread request " + qc.toString());

        proxyClient.execute(
            context.xavier().config().proxyConfig().host(),
            new BasicAsyncRequestProducerGenerator(qc.toString()),
            ProxyCategoryConsumerFactory.INSTANCE,
            context.session().listener().createContextGeneratorFor(proxyClient),
            callback);
    }
}
