package ru.yandex.search.mail.xavier.proxy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;
import ru.yandex.json.xpath.ValueUtils;

public class ProxyCategoryConsumer
    extends AbstractJsonAsyncDomConsumer<Map<String, List<String>>>
{
    public ProxyCategoryConsumer(final HttpEntity entity) throws HttpException {
        super(entity);
    }

    @Override
    protected Map<String, List<String>> buildResult(
        final HttpContext context,
        final Object value)
        throws Exception
    {
        Map<?, ?> mapObj = ValueUtils.asMap(value);
        Map<String, List<String>> result = new LinkedHashMap<>(mapObj.size());

        for (Map.Entry<?, ?> item: mapObj.entrySet()) {
            String mid = ValueUtils.asString(item.getKey());
            List<?> categoriesObj = ValueUtils.asList(item.getValue());
            List<String> categories = new ArrayList<>(categoriesObj.size());
            for (Object category: categoriesObj) {
                categories.add(ValueUtils.asString(category));
            }

            result.put(mid, categories);
        }

        return result;
    }
}
