package ru.yandex.search.mail.xavier.proxy;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public final class ProxyCategoryConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Map<String, List<String>>>
{
    public static final StatusCheckAsyncResponseConsumerFactory<Map<String,
        List<String>>> INSTANCE =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            new ProxyCategoryConsumerFactory());

    private ProxyCategoryConsumerFactory() {
    }

    @Override
    public HttpAsyncResponseConsumer<Map<String, List<String>>> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new ProxyCategoryConsumer(response.getEntity());
    }
}
