package ru.yandex.search.mail.xavier.proxy;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;
import ru.yandex.json.xpath.ValueUtils;

public class ProxySearchCountConsumer
    extends AbstractJsonAsyncDomConsumer<Map<String, Integer>>
{
    private final List<String> categories;

    public ProxySearchCountConsumer(
        final HttpEntity entity,
        final List<String> categories)
        throws HttpException
    {
        super(entity);

        this.categories = categories;
    }

    @Override
    protected Map<String, Integer> buildResult(
        final HttpContext context,
        final Object value)
        throws Exception
    {
        List<?> items = ValueUtils.asList(value);
        Map<String, Integer> result = new LinkedHashMap<>();

        if (items.size() != categories.size()) {
            throw new Exception(
                "Unexpected number of categories expected "
                    + categories.size()
                    + " but got " + items.size());
        }

        for (int i = 0; i < items.size(); i++) {
            result.put(categories.get(i), ValueUtils.asInt(items.get(i)));
        }

        return result;
    }
}
