package ru.yandex.search.mail.xavier.proxy;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class ProxySearchCountConsumerFactory implements
    HttpAsyncResponseConsumerFactory<Map<String, Integer>>
{
    private final List<String> categories;

    protected ProxySearchCountConsumerFactory(final List<String> categories) {
        this.categories = categories;
    }

    @Override
    public ProxySearchCountConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ProxySearchCountConsumer(response.getEntity(), categories);
    }
}
