package ru.yandex.search.mail.xavier.proxy;

import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.DoubleFutureCallback;

import ru.yandex.search.mail.xavier.Xavier;
import ru.yandex.search.mail.xavier.XavierContext;

public class ProxySearchStep {
    private final UnreadCountStep unreadCountStep;
    private final CategoriesFetchStep categoriesFetchStep;

    public ProxySearchStep(final Xavier xavier) {
        this.unreadCountStep = new UnreadCountStep(xavier);
        this.categoriesFetchStep = new CategoriesFetchStep(xavier);
    }

    public void fetch(
        final XavierContext context,
        final FutureCallback<Map.Entry<Map<String, Integer>, Map<String,
            List<String>>>> callback)
    {
        DoubleFutureCallback<Map<String, Integer>, Map<String, List<String>>>
            dcb =
            new DoubleFutureCallback<>(callback);

        unreadCountStep.fetch(context, dcb.first());
        categoriesFetchStep.fetch(context, dcb.second());
    }
}
