package ru.yandex.search.mail.xavier.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.mail.xavier.Xavier;
import ru.yandex.search.mail.xavier.XavierContext;
import ru.yandex.util.string.StringUtils;

public class UnreadCountStep {
    private final StatusCheckAsyncResponseConsumerFactory<Map<String,
        Integer>> consumerFactory;
    private final List<String> categories;

    public UnreadCountStep(final Xavier xavier) {
        this.categories = new ArrayList<>(xavier.config().categories());
        this.consumerFactory =
            new StatusCheckAsyncResponseConsumerFactory<>(
                HttpStatusPredicates.OK,
                new ProxySearchCountConsumerFactory(categories));
    }

    public void fetch(
        final XavierContext context,
        final FutureCallback<Map<String, Integer>> callback)
    {
        this.fetch(context, callback, false);
    }

    public void fetch(
        final XavierContext context,
        final FutureCallback<Map<String, Integer>> callback,
        final boolean warm)
    {
        AsyncClient proxyClient =
            context.xavier().proxyClient().adjust(context.session().context());
        QueryConstructor qc =
            new QueryConstructor(
                "/api/async/mail/tabs/count?unread=true&nolaf");
        try {
            qc.append("uid", context.user().prefix().toString());
            qc.append(
                "mdb",
                context.session().params().getString(OracleFields.MDB));
            qc.append(
                "filters",
                StringUtils.join(categories, ","));
            if (!warm) {
                qc.append("position", String.valueOf(context.queueId()));
            }
        } catch (BadRequestException bre) {
            callback.failed(bre);
            return;
        }

        context.session().logger().info("Unread request " + qc.toString());

        proxyClient.execute(
            context.xavier().config().proxyConfig().host(),
            new BasicAsyncRequestProducerGenerator(qc.toString()),
            consumerFactory,
            context.session().listener().createContextGeneratorFor(proxyClient),
            callback);
    }
}
