package ru.yandex.search.mail.xavier.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.JsonException;

import ru.yandex.search.mail.xavier.UnreadCountCache.UserReadStat;
import ru.yandex.search.mail.xavier.XavierContext;

public class CachedFetchSession extends FetchSession {
    private static final Set<String> NC_FOLDERS =
        new HashSet<>(
            Arrays.asList("sent", "draft", "trash", "spam"));

    private static final String SYMBOLIC_NAME = "symbolicName";
    private static final String SYSTEM = "system";
    private static final String TITLE = "title";
    private static final String TYPE = "type";

    private final XavierContext context;
    private final UserReadStat stat;

    public CachedFetchSession(
        final XavierContext context,
        final UserReadStat stat,
        final FutureCallback<XavierData> callback)
    {
        super(callback, 2);

        this.context = context;
        this.stat = stat;
    }

    protected synchronized void completed() {
        if (done) {
            return;
        }

        done = true;
        try {
            JsonList envelopeList =
                xavierData.envelopes().get("envelopes").asList();

            for (JsonObject envObj: envelopeList) {
                JsonMap envelope = envObj.asMap();
                String mid = envelope.getString("mid");
                JsonMap folder = envelope.get("folder").asMap();
                String folderType = folder.get(TYPE).get(TITLE).asString();
                if (folderType.equals(SYSTEM)) {
                    folderType =
                        folder.get(SYMBOLIC_NAME).get(TITLE).asString().trim()
                            .toLowerCase(Locale.ROOT);
                    if (NC_FOLDERS.contains(folderType)) {
                        continue;
                    }
                }

                boolean seen = false;
                JsonObject labelsObj = envelope.get("labels");
                if (labelsObj != null) {
                    JsonList labelsList = labelsObj.asList();
                    for (int i = labelsList.size() - 1; i >= 0; i--) {
                        String label = labelsList.get(i).asStringOrNull();
                        if ("FAKE_SEEN_LBL".equalsIgnoreCase(label)) {
                            seen = true;
                            break;
                        }
                    }
                }

                if (seen) {
                    continue;
                }

                List<String> categories = xavierData.categories().get(mid);
                if (categories != null) {
                    categories.forEach(stat::inc);
                }
            }
        } catch (JsonException je) {
            // remove
            context.xavier().unreadCountCache()
                .remove(context.prefix().prefix());

            callback.failed(je);
            return;
        }

        xavierData.counters(stat.asMap());
        callback.completed(xavierData);
    }
}
