package ru.yandex.search.mail.xavier.store;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.search.mail.xavier.UnreadCountCache.UserReadStat;
import ru.yandex.search.mail.xavier.XavierContext;

public class CachingFetchSession extends FetchSession {
    private final XavierContext context;

    public CachingFetchSession(
        final XavierContext context,
        final FutureCallback<XavierData> callback)
    {
        super(callback);

        this.context = context;
    }

    @Override
    public void countersCompleted(
        final Map<String, Integer> counters)
    {
        super.countersCompleted(counters);

        UserReadStat stat =
            this.context.xavier().unreadCountCache().put(
                context.prefix().prefix(),
                counters);
        context.session().logger().info(
            "Cache put " + context.prefix() + ' ' + stat.asMap().toString());
    }
}
