package ru.yandex.search.mail.xavier.store;

import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

public class CategoriesCallback
    implements FutureCallback<Map<String, List<String>>>
{
    private final FetchSession session;

    public CategoriesCallback(final FetchSession session) {
        this.session = session;
    }

    @Override
    public void completed(final Map<String, List<String>> categories) {
        this.session.categoryCompleted(categories);
    }

    @Override
    public void failed(final Exception e) {
        session.failed(e);
    }

    @Override
    public void cancelled() {
        session.cancelled();
    }
}
