package ru.yandex.search.mail.xavier.store;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonObject;

public class FetchSession {
    private static final int DEFAULT_REQUESTS = 3;

    protected final FutureCallback<XavierData> callback;

    protected final AtomicInteger left;
    protected final XavierData xavierData;

    protected boolean done = false;

    public FetchSession(final FutureCallback<XavierData> callback) {
        this(callback, DEFAULT_REQUESTS);
    }

    public FetchSession(
        final FutureCallback<XavierData> callback,
        final int requests)
    {
        this.callback = callback;
        this.left = new AtomicInteger(requests);
        this.xavierData = new XavierData();
    }

    private void checkCompleted() {
        if (left.decrementAndGet() == 0) {
            completed();
        }
    }

    protected synchronized void completed() {
        System.out.println("Fetch Completed");
        if (done) {
            return;
        }

        done = true;
        callback.completed(xavierData);
    }

    public void fsCompleted(final JsonObject envelopes) {
        this.xavierData.envelopes(envelopes);
        this.checkCompleted();
    }

    public void categoryCompleted(final Map<String, List<String>> categories) {
        this.xavierData.categories(categories);
        this.checkCompleted();
    }

    public void countersCompleted(final Map<String, Integer> counters) {
        this.xavierData.counters(counters);
        this.checkCompleted();
    }

    public synchronized void failed(final Exception e) {
        if (done) {
            return;
        }

        done = true;
        callback.failed(e);
    }

    public synchronized void cancelled() {
        if (done) {
            return;
        }

        done = true;
        callback.cancelled();
    }
}
