package ru.yandex.search.mail.xavier.store;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.json.dom.JsonObject;

public class FilterSearchCallback implements FutureCallback<JsonObject> {
    private final FetchSession session;

    public FilterSearchCallback(
        final FetchSession session)
    {
        this.session = session;
    }

    @Override
    public void completed(final JsonObject envelopes) {
        session.fsCompleted(envelopes);
    }

    @Override
    public void failed(final Exception e) {
        session.failed(e);
    }

    @Override
    public void cancelled() {
        session.cancelled();
    }
}
