package ru.yandex.search.mail.xavier.store;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

public class UnreadCountCallback
    implements FutureCallback<Map<String, Integer>>
{
    private final FetchSession session;

    public UnreadCountCallback(final FetchSession session) {
        this.session = session;
    }

    @Override
    public void completed(final Map<String, Integer> counters) {
        session.countersCompleted(counters);
    }

    @Override
    public void failed(final Exception e) {
        session.failed(e);
    }

    @Override
    public void cancelled() {
        session.cancelled();
    }
}
