package ru.yandex.search.mail.xavier.store;

import java.util.List;
import java.util.Map;

import ru.yandex.json.dom.JsonObject;

public class XavierData {
    private JsonObject envelopes;
    private Map<String, Integer> counters;
    private Map<String, List<String>> categories;

    public XavierData() {
    }

    public XavierData(
        final JsonObject envelopes,
        final Map<String, Integer> counters,
        final Map<String, List<String>> categories)
    {
        this.envelopes = envelopes;
        this.counters = counters;
        this.categories = categories;
    }

    public JsonObject envelopes() {
        return envelopes;
    }

    public XavierData envelopes(final JsonObject envelopes) {
        this.envelopes = envelopes;
        return this;
    }

    public XavierData counters(
        final Map<String, Integer> counters)
    {
        this.counters = counters;
        return this;
    }

    public Map<String, Integer> counters() {
        return counters;
    }

    public XavierData categories(
        final Map<String, List<String>> categories)
    {
        this.categories = categories;
        return this;
    }

    public Map<String, List<String>> categories() {
        return categories;
    }
}
