package ru.yandex.search.mail.xavier.update;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.entity.ContentType;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.JsonException;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.mail.xavier.XavierContext;

import ru.yandex.search.mail.xavier.store.StoreUnreadCountCallback;
import ru.yandex.search.mail.xavier.store.StoreXavierHandler.XivaCallback;
import ru.yandex.search.mail.xavier.store.XavierData;

public class StatusChangeCallback extends StoreUnreadCountCallback {
    public StatusChangeCallback(final XavierContext context) {
        super(context);
    }

    @Override
    protected void process(
        final AsyncClient client,
        final XavierData data)
        throws IOException, JsonException, BadRequestException
    {
        context.session().logger().info(
            "Xiva request "
                + buildRequest(
                data.envelopes(),
                data.counters(),
                data.categories())
                .toString());

        client.execute(
            context.xavier().config().xivaConfig().host(),
            buildRequest(
                data.envelopes(),
                data.counters(),
                data.categories()),
            EmptyAsyncConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(client),
            new XivaCallback(context));
    }

    // CSOFF: MultipleStringLiterals
    // CSOFF: ParameterNumber
    private void message(
        final JsonWriter writer,
        final JsonObject envelopes,
        final Map<String, Integer> counters,
        final Map<String, List<String>> categories)
        throws IOException, JsonException
    {
        writer.startObject();
        writer.key("lcn");
        writer.value(context.lcn());
        writer.key("method_id");
        writer.value("");
        writer.key("mids");
        writer.value(context.mids());

        writer.key("operation");
        writer.value("status change");
        writer.key("session_key");
        writer.value("");
        writer.key("status");
        writer.value("RO");
        writer.key("uid");
        writer.value(context.user().prefix().toString());

        writer.key("categories");
        writer.value(categories);

        writer.key("counters");
        writer.startObject();
        for (Map.Entry<String, Integer> entry : counters.entrySet()) {
            writer.key(entry.getKey());
            writer.startObject();
            writer.key("unread");
            writer.value(entry.getValue());
            writer.endObject();
        }

        writer.endObject();
        writer.endObject();
    }
    // CSON: ParameterNumber

    private BasicAsyncRequestProducerGenerator buildRequest(
        final JsonObject envelopes,
        final Map<String, Integer> counters,
        final Map<String, List<String>> categories)
        throws IOException, JsonException, BadRequestException
    {
        QueryConstructor qc = new QueryConstructor("/v2/send?");
        qc.append("ttl", 0);
        qc.append(
            "token",
            context.xavier().config().xivaConfig().notifyToken());
        qc.append("user", context.prefix().toString());
        qc.append("event", "msearch_status_change");
        qc.append("lcn", context.lcn().toString());

        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = JsonWriter.create(sbWriter)) {
            writer.startObject();
            writer.key("payload");
            writer.startObject();
            writer.key("message");
            message(writer, envelopes, counters, categories);
            writer.key("operation");
            writer.value("unsupported");
            writer.key("service");
            writer.value("msearch");
            writer.key("uid");
            writer.value(context.user().prefix().toString());
            writer.key("tags");
            writer.startArray();
            writer.endArray();
            writer.key("version");
            writer.value("1");
            writer.key("raw_data");
            message(writer, envelopes, counters, categories);
            //writer.key("uid");
            //writer.value(context.user().prefix().toString());
            //writer.key("envelopes");
            //writer.value(envelopes);
            writer.endObject();
            writer.endObject();
        }

        return new BasicAsyncRequestProducerGenerator(
            qc.toString(),
            sbWriter.toString(),
            ContentType.APPLICATION_JSON);
    }
    // CSON: MultipleStringLiterals
}
