package ru.yandex.search.mail.xavier.usertype;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpResponse;

import org.apache.http.entity.ContentType;

import ru.yandex.client.producer.ProducerClient;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.mail.xavier.XavierContext;

public class UserTypeProducerCallback
    extends AbstractFilterFutureCallback<HttpResponse, Object>
{
    private final XavierContext context;
    private final ProducerClient client;
    private final boolean hasExtra;

    public UserTypeProducerCallback(
        final XavierContext context,
        final ProducerClient client,
        final boolean hasExtra)
    {
        super(context.callback());

        this.context = context;
        this.client = client;
        this.hasExtra = hasExtra;
    }

    private BasicAsyncRequestProducerGenerator buildRequest()
        throws BadRequestException, IOException
    {
        QueryConstructor uri =
            new QueryConstructor(context.xavier().config().indexUri());

        uri.append("service", context.xavier().config().pgQueue());
        uri.append("prefix", context.prefix().toString());
        uri.append("mdb", context.user().service());

        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = JsonWriter.create(sbWriter)) {
            writer.value(context.json());
        }

        return new BasicAsyncRequestProducerGenerator(
            uri.toString(),
            sbWriter.toString(),
            ContentType.APPLICATION_JSON);
    }

    @Override
    public void completed(final HttpResponse response) {
        if (!hasExtra) {
            callback.completed(null);
        } else {
            try {
                client.execute(
                    context.xavier().config().producerConfig().host(),
                    buildRequest(),
                    BasicAsyncResponseConsumerFactory.OK,
                    new UserTypeProducerCallback(context, client, false));
            } catch (BadRequestException | IOException e) {
                context.session().logger().log(
                    Level.SEVERE,
                    "Unable construct producer request",
                    e);
                failed(e);
                return;
            }
        }
    }
}
