package ru.yandex.zora.proxy;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.logger.PrefixedLogger;

public class BaseImageLoadCallback implements FutureCallback<Image> {
    protected final PrefixedLogger logger;
    protected final String url;
    protected final ZoraCache cache;

    protected BaseImageLoadCallback(
        final ZoraCache cache,
        final PrefixedLogger logger,
        final String url)
    {
        this.logger = logger;
        this.url = url;
        this.cache = cache;
    }

    @Override
    public void completed(final Image image) {
        cache.downloaded().put(url, image);
        cache.pending().remove(url);
        logger.info(
            url + " fetched " + image.width() + ' ' + image.height());
    }

    @Override
    public void failed(final Exception e) {
        cache.pending().remove(url);
        logger.log(Level.WARNING, "Url fetch failed", e);
    }

    @Override
    public void cancelled() {
        cache.pending().remove(url);
        logger.warning("Url fetch cancelled");
    }
}
