package ru.yandex.zora.proxy;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

public class DownloadTask {
    private final String url;
    private final long createTs;
    private final List<FutureCallback<Image>> callbacks;

    private boolean done;
    private long downloadTime;
    private Image result;
    private Exception error;

    public DownloadTask(final String url) {
        this.url = url;
        this.done = false;
        this.createTs = System.currentTimeMillis();
        this.callbacks = new ArrayList<>();
    }

    public void subscribeForCancellation(final FutureCallback<Image> cb) {
        this.callbacks.add(cb);
    }

    public List<FutureCallback<Image>> callbacks() {
        return callbacks;
    }

    public String url() {
        return url;
    }

    public long createTs() {
        return createTs;
    }

    public boolean done() {
        return done;
    }

    public Image result() {
        return result;
    }

    public Exception error() {
        return error;
    }

    public void finish(final Image image) {
        this.result = image;
        this.done = true;
        this.downloadTime = System.currentTimeMillis() - this.createTs;
    }

    public void fail(final Exception e) {
        this.error = e;
        this.done = true;
        this.downloadTime = System.currentTimeMillis() - this.createTs;
    }

    public long downloadTime() {
        return this.downloadTime;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DownloadTask that = (DownloadTask) o;

        return url.equals(that.url);
    }

    @Override
    public int hashCode() {
        return url.hashCode();
    }
}
